'use strict';

let run = (() => {
  var _ref = _asyncToGenerator(function* (path, pkg, options, isWarmUp) {
    try {
      options.isWarmUp = isWarmUp;
      return yield pipeline.process(path, pkg, options);
    } catch (e) {
      e.fileName = path;
      throw e;
    }
  });

  return function run(_x, _x2, _x3, _x4) {
    return _ref.apply(this, arguments);
  };
})();

// request.location is a module path relative to src or lib


let addCall = (() => {
  var _ref2 = _asyncToGenerator(function* (request, awaitResponse = true) {
    if (process.send && process.env.WORKER_TYPE === 'parcel-worker') {
      return child.addCall(request, awaitResponse);
    } else {
      return WorkerFarm.getShared().processRequest(request);
    }
  });

  return function addCall(_x5) {
    return _ref2.apply(this, arguments);
  };
})();

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

require('v8-compile-cache');
const Pipeline = require('./Pipeline');
const child = require('./workerfarm/child');
const WorkerFarm = require('./workerfarm/WorkerFarm');

let pipeline;

function init(options, isLocal = false) {
  pipeline = new Pipeline(options || {});
  Object.assign(process.env, options.env || {});
  process.env.HMR_PORT = options.hmrPort;
  process.env.HMR_HOSTNAME = options.hmrHostname;
  if (isLocal) {
    process.env.WORKER_TYPE = 'parcel-worker';
  }
}

exports.init = init;
exports.run = run;
exports.addCall = addCall;