"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const postcss = require("postcss");
const trim_1 = require("./stylePlugins/trim");
const scoped_1 = require("./stylePlugins/scoped");
function compileStyle(options) {
    const { source, filename, id, map, scoped = true, trim = true } = options;
    const plugins = [];
    if (trim) {
        plugins.push(trim_1.default());
    }
    if (scoped) {
        plugins.push(scoped_1.default(id));
    }
    const postCSSOptions = {
        to: filename,
        from: filename
    };
    if (map) {
        postCSSOptions.map = {
            inline: false,
            annotation: false,
            prev: map
        };
    }
    let result, code, outMap;
    const errors = [];
    try {
        result = postcss(plugins).process(source, postCSSOptions);
        // force synchronous transform (we know we only have sync plugins)
        code = result.css;
        outMap = result.map;
    }
    catch (e) {
        errors.push(e);
    }
    return {
        code: code || ``,
        map: outMap && outMap.toJSON(),
        errors,
        rawResult: result
    };
}
exports.compileStyle = compileStyle;
